/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.shaders.GradientShader;
import icyllis.arc3d.core.shaders.Shader;
import icyllis.modernui.annotation.ColorInt;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.annotation.Size;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.GradientShader;
import icyllis.modernui.graphics.Matrix;
import icyllis.modernui.graphics.Shader;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Objects;

public class AngularGradient
extends GradientShader {
    private final Matrix mLocalMatrix;

    public AngularGradient(float centerX, float centerY, @ColorInt int startColor, @ColorInt int endColor, @Nullable Matrix localMatrix) {
        this(centerX, centerY, 0.0f, 360.0f, new int[]{startColor, endColor}, null, Shader.TileMode.CLAMP, localMatrix);
    }

    public AngularGradient(float centerX, float centerY, @NonNull @ColorInt int[] colors, @Nullable float[] positions, @Nullable Matrix localMatrix) {
        this(centerX, centerY, 0.0f, 360.0f, colors, positions, Shader.TileMode.CLAMP, localMatrix);
    }

    public AngularGradient(float centerX, float centerY, float startAngle, float endAngle, @ColorInt int centerColor, @ColorInt int edgeColor, @NonNull Shader.TileMode tileMode, @Nullable Matrix localMatrix) {
        this(centerX, centerY, startAngle, endAngle, new int[]{centerColor, edgeColor}, null, tileMode, localMatrix);
    }

    public AngularGradient(float centerX, float centerY, float startAngle, float endAngle, @NonNull @ColorInt int[] colors, @Nullable float[] positions, @NonNull Shader.TileMode tileMode, @Nullable Matrix localMatrix) {
        this(centerX, centerY, startAngle, endAngle, AngularGradient.convertColors(colors), null, positions, tileMode, localMatrix);
    }

    public AngularGradient(float centerX, float centerY, float startAngle, float endAngle, @Size(multiple=4L) @NonNull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, @NonNull Shader.TileMode tileMode, @Nullable Matrix localMatrix) {
        this(centerX, centerY, startAngle, endAngle, colors, colorSpace, positions, colors.length / 4, tileMode, GradientShader.Interpolation.make(true, (byte)0, (byte)0), localMatrix);
    }

    private AngularGradient(float centerX, float centerY, float startAngle, float endAngle, @Size(multiple=4L) @NonNull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, int colorCount, @NonNull Shader.TileMode tileMode, int interpolation, @Nullable Matrix localMatrix) {
        if (colorCount < 1) {
            throw new IllegalArgumentException("needs >= 1 number of colors");
        }
        Shader shader = icyllis.arc3d.core.shaders.AngularGradient.make(centerX, centerY, startAngle, endAngle, colors, colorSpace != null ? colorSpace : ColorSpace.get(ColorSpace.Named.SRGB), positions, colorCount, tileMode.nativeInt, interpolation, localMatrix);
        if (shader == null) {
            throw new IllegalArgumentException("incomplete arrays, points are NaN, infinity, or matrix is singular");
        }
        this.mLocalMatrix = localMatrix != null && !localMatrix.isIdentity() ? new Matrix(localMatrix) : null;
        this.mCleanup = Core.registerNativeResource((Object)this, shader);
        this.mShader = shader;
    }

    public boolean getLocalMatrix(@NonNull Matrix localMatrix) {
        if (this.mLocalMatrix != null) {
            localMatrix.set(this.mLocalMatrix);
            return true;
        }
        return false;
    }

    public static class Builder
    extends GradientShader.Builder {
        final float mCenterX;
        final float mCenterY;
        final float mStartAngle;
        final float mEndAngle;
        @NonNull
        final Shader.TileMode mTileMode;
        @Nullable
        final ColorSpace mColorSpace;
        @NonNull
        final FloatArrayList mColors;
        @Nullable
        FloatArrayList mPositions;
        @Nullable
        Matrix mLocalMatrix;

        public Builder(float centerX, float centerY, float startAngle, float endAngle, @NonNull Shader.TileMode tileMode) {
            this(centerX, centerY, startAngle, endAngle, tileMode, null);
        }

        public Builder(float centerX, float centerY, float startAngle, float endAngle, @NonNull Shader.TileMode tileMode, @Nullable ColorSpace colorSpace) {
            this.mCenterX = centerX;
            this.mCenterY = centerY;
            this.mStartAngle = startAngle;
            this.mEndAngle = endAngle;
            this.mTileMode = Objects.requireNonNull(tileMode);
            this.mColorSpace = colorSpace;
            this.mColors = new FloatArrayList();
        }

        public Builder(float centerX, float centerY, float startAngle, float endAngle, @NonNull Shader.TileMode tileMode, @Nullable ColorSpace colorSpace, int colorCount) {
            if (colorCount < 1) {
                throw new IllegalArgumentException("needs >= 1 number of colors");
            }
            if (colorCount > 0x1FFFFFFF) {
                throw new IllegalArgumentException("needs <= 536,870,911 number of colors");
            }
            this.mCenterX = centerX;
            this.mCenterY = centerY;
            this.mStartAngle = startAngle;
            this.mEndAngle = endAngle;
            this.mTileMode = Objects.requireNonNull(tileMode);
            this.mColorSpace = colorSpace;
            this.mColors = new FloatArrayList(colorCount * 4);
        }

        @NonNull
        public Builder addColor(@ColorInt int color) {
            this.mColors.add((float)(color >> 16 & 0xFF) * 0.003921569f);
            this.mColors.add((float)(color >> 8 & 0xFF) * 0.003921569f);
            this.mColors.add((float)(color & 0xFF) * 0.003921569f);
            this.mColors.add((float)(color >>> 24) * 0.003921569f);
            return this;
        }

        @NonNull
        public Builder addColor(float r, float g, float b, float a) {
            this.mColors.add(r);
            this.mColors.add(g);
            this.mColors.add(b);
            this.mColors.add(a);
            return this;
        }

        @NonNull
        public Builder addPosition(float position) {
            if (this.mPositions == null) {
                this.mPositions = new FloatArrayList(this.mColors.elements().length / 4);
            }
            this.mPositions.add(position);
            return this;
        }

        @NonNull
        public Builder addColorStop(float offset, @ColorInt int color) {
            return this.addColor(color).addPosition(offset);
        }

        public int getColorCount() {
            return this.mColors.size() / 4;
        }

        @Override
        public Builder setInterpolationInPremul(boolean interpolationInPremul) {
            super.setInterpolationInPremul(interpolationInPremul);
            return this;
        }

        @Override
        public Builder setInterpolationColorSpace(@NonNull GradientShader.InterpolationColorSpace interpolationColorSpace) {
            super.setInterpolationColorSpace(interpolationColorSpace);
            return this;
        }

        @Override
        public Builder setHueInterpolationMethod(@NonNull GradientShader.HueInterpolationMethod hueInterpolationMethod) {
            super.setHueInterpolationMethod(hueInterpolationMethod);
            return this;
        }

        @NonNull
        public Builder setLocalMatrix(@Nullable Matrix localMatrix) {
            if (localMatrix == null || localMatrix.isIdentity()) {
                if (this.mLocalMatrix != null) {
                    this.mLocalMatrix.setIdentity();
                }
            } else if (this.mLocalMatrix == null) {
                this.mLocalMatrix = new Matrix(localMatrix);
            } else {
                this.mLocalMatrix.set(localMatrix);
            }
            return this;
        }

        @Override
        @NonNull
        public AngularGradient build() {
            int colorCount = this.getColorCount();
            if (this.mPositions != null && colorCount != this.mPositions.size()) {
                throw new IllegalArgumentException("color and position arrays must be of equal length");
            }
            return new AngularGradient(this.mCenterX, this.mCenterY, this.mStartAngle, this.mEndAngle, this.mColors.elements(), this.mColorSpace, this.mPositions != null ? this.mPositions.elements() : null, colorCount, this.mTileMode, GradientShader.Interpolation.make(this.mInterpolationInPremul, this.mInterpolationColorSpace.nativeByte, this.mHueInterpolationMethod.nativeByte), this.mLocalMatrix);
        }
    }
}

